# LSaddon_mail

Cet [LSaddon](index.md#configuration-des-lsaddons) est utilisé pour gérer l'envoi de courriels. Il
utilise pour cela les librairies [PEAR](http://pear.php.net/) *Mail* et *Mail_Mime* qui doivent être
installés.

Cet [LSaddon](index.md#configuration-des-lsaddons) offre aussi la possibilité d'envoyer des
courriels dont le contenu est construit à partir de modèles. Ces modèles sont enregistrés dans des
fichiers textes stockés (voir `$GLOBALS['MAIL_TEMPLATES_DIRECTORIES']`). Pour chaque modèle, vous
devez fournir trois fichiers portant le même nom mais avec des extensions différentes :

- `template.subject` : le sujet du courriel. Note : seule la première ligne du fichier est utilisé
  (et passée dans la fonction `trim()`)
- `template.html` : le contenu HTML du courriel
- `template.txt`: le contenu texte du courriel

Ces trois fichiers sont utilisés en tant que modèle [Smarty](http://www.smarty.net/) et seront
construit en utilisant les variables fournies dans le contexte d'envoi des courriels. À noter que le
moteur Smarty utilisé pour la génération du contenu de ces courriels n'est pas le même que celui
utilisé par LdapSaisie pour l'affichage des pages.

Par ailleurs, cet [LSaddon](index.md#configuration-des-lsaddons) fourni une vue de gestion des
modèles de courriels existants (voir `$GLOBALS['MAIL_TEMPLATES_EDITOR_VIEW_ACCESS']` pour la
configuration des accès).

/// warning | Attention
Cette vue n'est pas conçues pour être mise entre toutes les mains. La sécurisation de modèles de
courriels étant très complexe, il est fortement recommandé de n'ouvrir l'accès à cette vue
qu'aux utilisateurs avertis et de confiances.
///

Cet [LSaddon](index.md#configuration-des-lsaddons) doit être configuré en éditant son
fichier de configuration `config.LSaddons.mail.php`.

```php
/*
 ***********************************************
 *          Send mail configuration            *
 ***********************************************
 */

// Pear :: Mail
define('PEAR_MAIL','/usr/share/php/Mail.php');

// Pear :: Mail_mime
define('PEAR_MAIL_MIME','/usr/share/php/Mail/mime.php');

// Html2Text
define('HTML2TEXT','/usr/share/php/Html2Text.php');

/*
 * Send method :
 *  - mail: using PHP mail() function
 *  - sendmail: using sendmail command
 *  - smtp: via SMTP server
 *  - discard: transparently discard outgoing email
 */
$GLOBALS['MAIL_SEND_METHOD'] = 'smtp';

/*
 * Sending parameters:
 *
 * Depend on send method, please consult PEAR :: Mail documentation for details:
 * Link: http://pear.php.net/manual/en/package.mail.mail.factory.php
 *
 * mail
 *    o If safe mode is disabled, $params will be passed as the fifth
 *      argument to the PHP mail() function. If $params is an array,
 *      its elements will be joined as a space-delimited string.
 * sendmail
 *    o $params["sendmail_path"] - The location of the sendmail program
 *      on the filesystem. Default is /usr/bin/sendmail.
 *    o $params["sendmail_args"] - Additional parameters to pass to the
 *      sendmail. Default is -i.
 * smtp
 *    o $params["host"] - The server to connect. Default is localhost.
 *    o $params["port"] - The port to connect. Default is 25.
 *    o $params["auth"] - Whether or not to use SMTP authentication.
 *      Default is FALSE.
 *    o $params["username"] - The username to use for SMTP authentication.
 *    o $params["password"] - The password to use for SMTP authentication.
 *    o $params["localhost"] - The value to give when sending EHLO or HELO.
 *      Default is localhost
 *    o $params["timeout"] - The SMTP connection timeout.
 *      Default is NULL (no timeout).
 *    o $params["verp"] - Whether to use VERP or not. Default is FALSE.
 *    o $params["debug"] - Whether to enable SMTP debug mode or not.
 *      Default is FALSE.
 *    o $params["persist"] - Indicates whether or not the SMTP connection
 *      should persist over multiple calls to the send() method.
 */
$GLOBALS['MAIL_SEND_PARAMS'] = NULL;

/*
 * Headers :
 */
$GLOBALS['MAIL_HEARDERS'] = [];

// Catch all sent emails
$GLOBALS['MAIL_CATCH_ALL'] = [];

/**
 * Email templates
 *
 * This addon offer ability to send email by using templates. Email templates are stored in
 * full-text files in configured directories (see $GLOBALS['MAIL_TEMPLATES_DIRECTORIES']). For each
 * template, you have to provide three files with the same name but with different extensions:
 * - template.subject: the email subject. Note: only the first line is used (and stripped)
 * - template.html: the HTML content of the email
 * - template.txt: the text content of the email
 * All these files will be used as Smarty templates and will be computed using variables provided
 * in the sending context. Note that the Smarty object used to compute the template is not the same
 * as the one used by LdapSaisie to display pages.
 *
 * Futhermore, this addon offer a view to list and edit existing template (see
 * $GLOBALS['MAIL_TEMPLATES_EDITOR_VIEW_ACCESS'] to configured access).
 */

// List of directory paths where as stored mail templates
// Notes:
// - provided path could be absolute or relative. Relative path are relative to the root base
//   sources LdapSaisie directory (commonly /usr/share/ldapsaisie or the src directory if you
//   installed it from sources). On Debian installation, you can specify 'local/email_templates' to
//   refer to /etc/ldapsaisie/local/email_templates directory/
// - Multiple directories could be specified, sorted so that the first ones take priority over
//   the last one.
// - To allow users to edit them using the editor view, these directories must be
//   writable by PHP process (commonly runed as www-data).
$GLOBALS['MAIL_TEMPLATES_DIRECTORIES'] = ['local/email_templates'];

// List of granted LSprofiles to access mail templates editor view
// WARNING: Sanitizing mail templates is hell... EXPOSE THIS VIEW ONLY TO TRUSTED USERS!
$GLOBALS['MAIL_TEMPLATES_EDITOR_VIEW_ACCESS'] = ['admin'];
```

Cet [LSaddon](index.md#configuration-des-lsaddons) offre avant tout la possibilité d'envoyer des
courriels en utilisant la fonction PHP `sendMail()` :

```
bool sendMail(
  <string> $to,
  <string> $subject,
  <string> $msg,
  <array(string)> $headers,
  <array> $attachments,
  <string> $eol,
  <string> $encoding,
  <boolean> $html
);
```

Pour l'envoi de courriels en utilisant un modèle, il faut utiliser la fonction PHP
`sendMailFromTemplate()` :

```
bool sendMailFromTemplate(
  <string> $tplname,
  <string> $to,
  <array> $variables,
  <array(string)> $headers,
  <array> $attachments
);
```
