# Recherche des objets dans l'annuaire (LSsearch)

Cette section décrit la manière de paramétrer les recherches dans l'annuaire pour un type
d'[LSobject](index.md#configuration-lsobject) donné.

La configuration des *LSsearch* se situe dans la configuration des
[LSobjects](index.md#configuration-lsobject), dans la variable `LSsearch`
(`$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSsearch']`).

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSsearch'] = array (
  'attrs' => array(
    'attr1',
    'attr2',
    ...
    'attr3' => array(
      'searchLSformat' => '[LSformat]',
      'approxLSformat' => '[LSformat]',
    ),
    ...
  ),
  'params' => array(
    // Paramètres de la recherche
    'pattern' => '[string]',
    'sizelimit' => [integer],
    'recursive' => [boolean],
    'approx' => [boolean],
    'withoutCache' => [boolean],
    'onlyAccessible' => [boolean],
    // Paramètres de tri
    'sortBy' => [displayName|subDn|extraDisplayedColumn],
    'sortDirection' => [ASC|DESC],
    'sortlimit' => [integer],
    // Paramètre d'affichage
    'displayFormat' => [LSformat],
    'nbObjectsByPage' => [integer],
    'nbObjectsByPageChoices' => array([integer], [integer], ...),
    'validPatternRegex' => '[regex]'
  ),
  'predefinedFilters' => array(
    'filter1' => 'label filter1',
    'filter2' => 'label filter2'
  ),
  'extraDisplayedColumns' => array(
    'col1' => array(
      'label' => 'label column 1',
      'LSformat' => '[LSformat]'
    ),
    'col2' => array(
      'label' => 'label column 2',
      'generateFunction' => '[fonction de génération]',
      'additionalAttrs' => array('[attr1]', '[attr2]', ...),
      'escape' => [booléen],
    ),
    'col3' => array(
      'label' => 'label column 3',
      'LSformat' => '[LSformat]',
      'alternativeLSformats' => array (
        '[LSformat 1]',
        '[LSformat 2]'
      ),
      'formaterLSformat' => '[LSformat]',
      'formaterFunction' => '[fonction de formatage]',
      'cssStyle' => '[CSS style]',
      'visibleTo' => array (
        '[LSprofile 1]',
        '[LSprofile 2]'
      )
    ),
  ),
  'customActions' =>  array (
    // Configuration des customActions pour les recherches de ce type d'objet
  ),
  'showSelectionBoxes' => [boolean],
);
```

- `attrs`

  Tableau listant les attributs pouvant être utilisés dans les filtres de recherche LDAP employés
  par LdapSaisie. Lorsqu'un motif de recherche est passé par l'utilisateur, LdapSaisie composera un
  filtre LDAP à partir de cette liste.

  Lors d'une recherche non-approximative, le filtre de recherche sera composé (par défaut) de la
  manière suivante :

  ```
  (|(attr1=*motif*)(attr2=*motif*)...)
  ```

  Lors d'une recherche approximative, le filtre de recherche sera composé (par défaut) de la manière
  suivante :

  ```
  (|(attr1=~motif)(attr2~=motif)...)
  ```

  Il est également possible de paramétrer la manière dont sera composé le filtre de recherche
  attribut par attribut à l'aide des paramètres `searchLSformat` et `approxLSformat`.

  /// tip | Filtrage automatique par *ObjectClass*
  Ces filtres, une fois composés, sont insérés dans un autre, filtrant en plus sur les
  *ObjectClass* du type d'[LSobject](index.md#configuration-lsobject) de la manière suivante :

  ```
  (& (&(objectclass=oc1)(objectclass=oc2)) (filtre) )
  ```
  ///

  - `searchLSformat`

    Ce paramètre est un [LSformat](../global/LSformat.md#format-parametrable) permettant de définir,
    attribut par attribut, comment le filtre de recherche LDAP est composé à partir d'un motif de
    recherche et en cas de recherche non-approximative.

    Ce [LSformat](../global/LSformat.md#format-parametrable) est composé à l'aide des éléments
    `name`, le nom de l'attribut et `pattern`, le motif de recherche.

    ```
    (%{name}=%{pattern})
    ```

    /// warning | Attention
    Le filtre déduit doit obligatoirement commencer par `(` et se terminer par `)`.
    ///

  - `approxLSformat`

    Ce paramètre est un [LSformat](../global/LSformat.md#format-parametrable) permettant de définir,
    attribut par attribut, comment le filtre de recherche LDAP est composé à partir d'un motif de
    recherche et en cas de recherche approximative.

    Ce [LSformat](../global/LSformat.md#format-parametrable) est composé à l'aide des éléments
    `name`, le nom de l'attribut et `pattern`, le motif de recherche.

    ```
    (%{name}=~%{pattern})
    ```

    /// warning | Attention
    Le filtre déduit doit obligatoirement commencer par `(` et se terminer par `)`.
    ///

- `params`

  Tableau des paramètres par défaut d'une recherche. Ce tableau contient les paramètres qui seront
  utilisés pour initialisé une recherche. Ces paramètres pourront être redéfini par l'utilisateur
  ou par l'application en fonction du contexte dans lequel cette recherche est effectuée.

  - `pattern`

    Mot clé de la recherche.

  - `sizelimit`

    Entier determinant le nombre maximum d'objet pouvant être retournés dans une recherche.

  - `recursive`

    Booléen déterminant si la recherche récursive est activée.

  - `approx`

    Booléen déterminant si la recherche approximative est activée.

  - `withoutCache`

    Booléen déterminant si le cache de recherche doit être utilisé.

  - `onlyAccessible`

    Booléen déterminant si seul les objets accessibles à l'utilisateur connecté doivent être
    retournés par la recherche.

  - `sortBy`

    Mot clé déterminant sur quel valeur/colonne le résultat de recherche sera trié.

    Valeurs possibles : `displayName`, `subDn`, le nom d'une des `extraDisplayedColumns` ou `NULL`.

  - `sortDirection`

    Mot clé déterminant le sens du trie du résultat de la recherche.

    Valeurs possibles : `ASC`, `DESC` ou `NULL`.

  - `sortlimit`

    Entier determinant le nombre maximum d'objet pouvant être triés dans le résultat d'une
    recherche.

  - `displayFormat`

    [LSformat](../global/LSformat.md#format-parametrable) d'affichage du nom de l'objet dans le
    résultat de la recherche.

  - `nbObjectsByPage`

    Entier déterminant le nombre d'objet maximum affichés dans une page de résultat de la recherche.

  - `nbObjectsByPageChoices`

    Tableau des choix proposés à l'utilisateur pour le nombre d'objets maximum affichés dans une
    page de résultat de la recherche.

  - `validPatternRegex`

    Expression régulière de validation des mots clés de recherche pour ce type
    d'[LSobject](index.md#configuration-lsobject).

    (Par défaut : `/^[\w\-_\\\'\"^[]\(\){}\=\+\£\%\$\€\.\:\;\,\?\/\@]+$/iu`)

- `predefinedFilters`

  Tableau associatif contenant des filtres prédéfinis pour la recherche. Les clés sont les filtres
  au format LDAP et les valeurs sont les labels associés.

- `extraDisplayedColumns`

  Tableau associatif contenant des colonnes supplémentaires à afficher dans les résultats de
  recherche. Les clés sont les identifiants des colonnes supplémentaires et les valeurs sont leur
  configuration définie à partir des paramètres suivant :

  - `label`

    Le label de la colonne.

  - `LSformat`

    Le [LSformat](../global/LSformat.md#format-parametrable) d'affichage de la colonne. Ce format
    est composé à partir des attributs des objets LDAP dans leur format brut.

  - `alternativeLSformats`

    Tableau des [LSformats](../global/LSformat.md#format-parametrable) alternatifs à utiliser si le
    résultat du format principal est vide. Les formats définis dans cette liste sont essayés les uns
    après les autres et le premier [LSformat](../global/LSformat.md#format-parametrable) retournant
    une valeur non-vide est utilisé.

  - `formaterLSformat`

    [LSformat](../global/LSformat.md#format-parametrable) optionnel permettant de mettre en forme le
    résultat obtenu des [LSformats](../global/LSformat.md#format-parametrable) précédents. Ce
    [LSformat](../global/LSformat.md#format-parametrable) ne sera utilisé que si le résultat obtenu
    précédement n'est pas vide. Il est ainsi possible d'utiliser les paramètres `LSformat` et
    `alternativeLSformats` afin de récupérer la valeur à afficher, puis de la mettre en forme grâce
    à ce [LSformat](../global/LSformat.md#format-parametrable). Ce format est composé à partir des
    attributs des objets LDAP dans leur format brut et de la valeur retournés précedement accessible
    via la variable `val`.

  - `formaterFunction`

    Le nom d'une fonction optionnelle à exécuter pour mettre en forme le résultat obtenu des
    [LSformats](../global/LSformat.md#format-parametrable) précédents. Cette fonction ne sera
    appelée que si le résultat obtenu précédement n'est pas vide. La fonction prendra en paramètre
    la valeur à mettre en forme et retournera la valeur mise en forme.

  - `generateFunction`

    Le nom d'une fonction qui sera utilisée pour générer la valeur d'affichage de cette colonne. La
    fonction prendra en paramètre une référence de l'objet `LSsearchEntry` et retournera la valeur
    de la colonne.

  - `additionalAttrs`

    Un tableau de nom d'attributs à inclure dans le resultat de la recherche LDAP. Ce tableau permet
    notamment d'inclure les attributs nécessaires au bon fonctionnement de la fonction
    `generateFunction`.

  - `escape`

    Ce paramètre booléen permet de définir si, lors de l'affichage, le contenu de la colonne doit
    être transformé pour protéger les caractères éligibles en entités HTML. Par défaut, ce paramètre
    est `True`.

    /// warning | Attention
    Cette fonctionnalité existe pour des raisons de sécurité et notamment en protection des
    failles `XSS`. Si vous désactivez cette fonctionnalité, il est important de gérer la
    problématique de sécurité par ailleurs.
    ///

  - `cssStyle`

    Ce paramètre permet de définir un style CSS personnalisé pour la colonne. S'il est défini, le
    contenu de ce paramètre sera ajouté en tant qu'attribut `style` des balises `th` et `td` de la
    colone.

  - `visibleTo`

    Ce paramètre permet de restreindre la visibilité de cette colonne aux seuls
    [LSprofiles](../global/ldap/LSprofile.md#profils-dutilisateurs) spécifiés. S'il est omis, la
    colonne sera visible pour tous.

- `customActions`

  Tableau associatif contenant les paramètres de configuration des
  [customActions](#customactions). [Voir la section concernée](#customactions).

- `showSelectionBoxes`

  Booléen permettant de définir si les cases à cocher de sélections des objets doivent être
  affichées. Lorsqu'elles sont affichées, l'utilisateur pourra sélectionner un ou plusieurs objets
  dans la liste avant de déclencher une [customAction](#customsactions). Dans ce cas, les DNs de ces
  objets seront passés à la page d'exécution de la [customAction](#customsactions) via le paramètre
  `selected`.

## Les actions personnalisées (customActions)

Cette section décrit la manière de configurer les actions personnalisées exécutables sur les
recherches d'[LSobjects](index.md#configuration-lsobject) appelées [customActions](#customactions).

```
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSsearch']['customActions'] = array (
  'action1' => array(
    'label' => '[label l'action]',
    'hideLabel' => '[booléen]',
    'icon' => '[nom de l'icône de l'action]',
    'function' => '[fonction à exécuter]',
    'question_format' => '[LSformat de la question de confirmation]',
    'onSuccessMsgFormat' => '[LSformat du message à afficher en cas de succès de l'action]',
    'disableOnSuccessMsg' => '[booléen]',
    'noConfirmation' => '[booléen]',
    'redirectToObjectList' => '[booléen]',
    'rights' => array(
      'LSprofile1',
      'LSprofile2',
      ...
    )
  )
);
```

- `label`

  Le label de l'action.

- `hideLabel`

  Cache le label dans le bouton de l'action.

- `icon`

  Nom de l'îcone à afficher dans le bouton de l'action. Ce nom correspond au nom du fichier de
  l'image (sans l'extention) qui devra se trouver dans le dossier
  `/src/images/[nom du theme d'images]/` ou dans le dossier `src/local/images`.

- `function`

  Le nom de la fonction à exécuter qui implémente l'action personnalisée Cette fonction prendra en
  seule paramètre l'objet [LSsearch](#lssearch). sur lequel l'action devra être exécutée et
  retournera `True` en cas de succès ou `False` en cas d'échec d'exécution de la fonction.

- `question_format`

  Le [LSformat](../global/LSformat.md#format-parametrable) de la question de confirmation
  d'exécution de l'action. Ce [LSformat](../global/LSformat.md#format-parametrable) sera composé à
  l'aide du label de l'action.

- `onSuccessMsgFormat`

  Le [LSformat](../global/LSformat.md#format-parametrable) du message à afficher en cas de succès
  d'exécution de l'action. Ce [LSformat](../global/LSformat.md#format-parametrable) sera composé à
  l'aide du label de l'action.

- `disableOnSuccessMsg`

  Booléen permetant de désactiver le message afficher en cas de succès d'exécution de l'action.

- `noConfirmation`

  Booléen permetant de désactiver la confirmation de l'exécution de l'action.

- `redirectToObjectList`

  Booléen permetant de rediriger ou non l'utilisateur vers la liste des objets (Vrai par défaut).
  Si l'utilisateur n'est redirigé, le template par défaut (ou celui défini durant l'éxécution de la
  fonction) sera affiché.

- `rights`

  Tableau contenant la liste des noms des [LSprofiles](../global/ldap/LSprofile.md#profils-dutilisateurs)
  ayant le droit d'exécuter cette action.

### Écriture d'une fonction implémentant une customAction

Une fonction implémentant une *customAction* se déclare de la manière suivante :

```php
/*
 * Ma fonction implémentant ma customAction
 *
 * Paramètre :
 *     - $search : L'objet LSsearch de la recherche sur lequel mon action doit être exécutée
 *
 * Valeurs retournées :
 *     - True : Tout s'est bien passé
 *     - False : Une erreur est survenue
 */
function maFonction ($search) {

  // Actions

}
```

Cette fonction doit prendre pour seul paramètre, l'objet [LSsearch](#lssearch). sur lequel l'action
personnalisée doit être exécutée et doit retourner soit `True` si tout s'est bien passé, soit
`False` en cas de problème.

/// warning | Attention
La recherche passée en paramètre n'a pas encore été exécutée. En conséquence, si vous avez
besoin d'accéder au résultat de la recherche, il est nécessaire d'exécuter au préalable :
`$search -> run();`. Cela permet en outre, de modifier les paramètres de la recherche avant de
l'exécuter. Cela peut par exemple être utile, si vous avez besoin d'accèder aux valeurs
d'attributs particuliers, d'ajouter des attributs au résultat de la recherche :

```php
$search -> setParam('attributes',array('attr1','attr2'));
```
///

/// note
Ces fonctions sont le plus couramment définies au sein
d'[LSaddon](../LSaddon/index.md#configuration-des-lsaddons).
///
