<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

LSsession :: loadLSclass('LSlog_staticLoggerClass');

/**
 * Driver to manage ioFormat file of LSldapObject import/export
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSioFormatDriver extends LSlog_staticLoggerClass {

  /**
   * Driver options
   * (LSobjects.<type>.ioFormat.<name>.driver_options)
   * @see LSioFormat::__construct()
   * @see LSioFormatDriver::__construct()
   * @see LSioFormatDriver::getOption()
   * @var array
   */
  protected $options = array();

  /**
   * Constructor
   *
   * @param array $options Driver's options
   *
   * @return void
   **/
  public function __construct($options) {
    $this -> options = $options;
  }

  /**
   * Load file
   *
   * @param string $path The file path to load
   *
   * @return boolean True if file is loaded, false otherwise
   **/
  public function loadFile($path) {
    return False;
  }

  /**
   * Check if loaded file data are valid
   *
   * @return boolean True if loaded file data are valid, false otherwise
   **/
  public function isValid() {
    return False;
  }

  /**
   * Retrieve all object data contained by the loaded file
   *
   * The objects are returned in array :
   *
   *  array (
   *    array ( // Object 1
   *      '[field1]' => '[value1]',
   *      '[field2]' => '[value2]',
   *      [...]
   *    ),
   *    array ( // Object 2
   *      '[field1]' => '[value1]',
   *      '[field2]' => '[value2]',
   *      [...]
   *    ),
   *  )
   *
   * @return array The objects contained by the loaded file
   **/
  public function getAll() {
    return array();
  }

  /**
   * Retrieve fields names of the loaded file
   *
   * The fields names are returned in array :
   *
   *  array (
   *    '[field1]',
   *    '[field2]',
   *    [...]
   *  )
   *
   * @return array The fields names of the loaded file
   **/
  public function getFieldNames() {
    return array();
  }

  /**
   * Retrieve all objects data of the loaded file formated
   *
   * This method format objects data using ioFormat configuration
   * given as parameters.
   *
   * @param array $fields of file's fields name mapping with object attribute
   * @param array $generated_fields of object attribute to generate using other object data
   *
   * @return array|false All objects data of the loaded file formated, or false
   **/
  public function getAllFormated($fields, $generated_fields) {
    if (!is_array($fields)) return False;
    if (!is_array($generated_fields)) $generated_fields=array();
    $all = $this -> getAll();
    if (!is_array($all)) return False;
    $retall = array();
    foreach($all as $idx => $one) {
      $retone = array();
      foreach($fields as $key => $attr) {
        if (!isset($one[$key])) continue;
        if (!isset($retone[$attr])) $retone[$attr] = array();
        $retone[$attr][] = $one[$key];
      }
      foreach ($generated_fields as $attr => $formats) {
        $retone[$attr] = array();
        if (is_callable($formats)) {
          $retone[$attr] = call_user_func_array($formats, array($retone, $one));
          if ($retone[$attr] === false) {
            LSerror :: addErrorCode(
              'LSioFormatDriver_01',
              array('attr' => $attr, 'object' => (is_int($idx)?"#$idx":"'$idx'"))
            );
            continue 2;
          }
          $retone[$attr] = ensureIsArray($retone[$attr]);
        }
        else {
          foreach (ensureIsArray($formats) as $format) {
            $value = getFData($format, $retone);
            if (!is_empty($value)) {
              $retone[$attr][] = $value;
            }
          }
        }
        if (empty($retone[$attr]))
          unset($retone[$attr]);
      }
      $retall[] = $retone;
    }

    return $retall;
  }

  /**
   * Export objects data
   *
   * @param array $objects_data of objects data to export
   * @param resource|null $stream The output stream (optional, default: STDOUT)
   *
   * @return boolean True on success, False otherwise
   */
  public function exportObjectsData($objects_data, $stream=null) {
    // Must be implement in real drivers
    return False;
  }

  /**
   * Return a option parameter (or default value)
   *
   * @param string $param      The configuration parameter
   * @param mixed $default    The default value (default : null)
   * @param string $cast       Cast resulting value in specific type (default : disabled)
   *
   * @return mixed The option parameter value or default value if not set
   **/
  public function getOption($param, $default=null, $cast=null) {
    return LSconfig :: get($param, $default, $cast, $this -> options);
  }

}

LSerror :: defineError('LSioFormatDriver_01',
___("LSioFormatDriver : Failed to generate the value of the attribute %{attr} of the object %{object}.")
);

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
